@extends('layouts.app')

@section('content')
<section class="right-sidebar" id="sidebarRight">
    <div class="view-release-sec">
        <div class="view-release">
            <div class="view-release-heading">
                <h6>View Artists</h6>
            </div>
            @can(['create-artists'])
            <div class="view-all-release-search">
                <a href="{{ route('artists.create') }}"><button class="btn vewReleaseBtn"><i class="fa-solid fa-plus"></i>Add New</button></a>
            </div>
            @endcan
        </div>

        <div class="viewReleases-main-sec">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Name</th>
                        <th>Email </th>
                        <th>Sound Cloud</th>
                        <th>Twitter</th>
                        <th>Facebook</th>
                        <th>Instagram</th>
                        <th>Youtube</th>
                        <th>Website</th>
                        <th>On Spotfy</th>
                        <th>Spotfy Link</th>
                        <th>On Apple</th>
                        <th>Apple Link</th>
                        <th width="280px">Action</th>
                    </tr>
                </thead>
                <tbody>

                    @foreach ($data as $key => $artist)
                    <tr>
                        <td>{{ ++$i }}</td>
                        <td>{{ $artist->name }}</td>
                        <td>{{ $artist->email }}</td>
                        <td>{{ $artist->sound_cloud }}</td>
                        <td>{{ $artist->twitter }}</td>
                        <td>{{ $artist->facebook }}</td>
                        <td>{{ $artist->instagram }}</td>
                        <td>{{ $artist->youtube }}</td>
                        <td>{{ $artist->website }}</td>
                        <td>{{ ($artist->is_on_spotfy) ? 'Yes' : 'No' }}</td>
                        <td>{{ $artist->spotfy_link }}</td>
                        <td>{{ ($artist->is_on_apple) ? 'Yes' : 'No' }}</td>
                        <td>{{ $artist->apple_link }}</td>

                        <td>

                            @can(['create-artists'])
                            <a class="btn btn-primary btn-sm" href="{{ route('artists.edit',$artist->id) }}"><i class="fa-solid fa-pen-to-square"></i> Edit</a>
                            @endcan

                            @can(['create-artists'])
                            <form method="POST" action="{{ route('artists.destroy', $artist->id) }}" style="display:inline">
                                @csrf
                                @method('DELETE')
                                <button onclick="return confirm('Are you sure you want to delete?');" type="submit" class="btn btn-danger btn-sm"><i class="fa-solid fa-trash"></i> Delete</button>
                            </form>
                            @endcan
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            {!! $data->links('pagination::bootstrap-5') !!}

            <!-- Delete Confirmation Modal -->
            <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            Are you sure you want to delete this genre?
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            <form id="deleteForm" method="POST" action="{{ route('genre.destroy', '') }}">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection